utils.attachEvent(window, 'load', __sfLoadHandler);

function __sfLoadHandler()
{
	utils.detachEvent(window, 'load', __sfLoadHandler);

	if (app == null)
	{
		window.getWindow().setTimeout(__sfLoadHandler, 100);
		return;
	}

	var manager = new specialFormsManager();
}

function specialFormsManager()
{
	window.ICApp.onformcreated.attach(__handleForm);

	function __handleForm(form)
	{
		if (form == null)
			return;

		if (form.name.startsWith('F574018_10'))
		{
			new F574018_10(form);
		}
	}

} 

function F574018_10(form)
{
	var
		_form = form,
		_ds = null,
		_lastControl = null,
		_title = null,
		_valueContainer = null,
		_grid = null;

	_form.onload.attach(load);
	_form.ondispose.attach(dispose);


	function load(form)
	{
		var style;

		_ds = _form.dataset; 
		_form.onload.detach(load);
		_ds.oncurrentrecordchanged.attach(dsChange);

		_grid = (_form.getControlsByType(JGrid))[0];

		_title = _form.$$().appendChild(_form.owner.getDocument().createElement('div'));
		style = _title.style;
		style.position = 'absolute';
		style.left = _grid.rect.left + _grid.$$().clientWidth + 20; 
		style.top = 24;
		style.height = 16;

		_valueContainer = _form.$$().appendChild(_form.owner.getDocument().createElement('div'));
		style = _valueContainer.style;
		style.position = 'absolute';
		style.left = _grid.rect.left + _grid.$$().clientWidth + 30; 
		style.top = 40;
		style.width = 200;
		style.height = 21;

		dsChange();
	}

	function dsChange()
	{
		if (_lastControl != null)
			_lastControl.dispose();

		var value = parseInt(_ds.get('580734,10')); // type of attachment; 1=Obrazek; 2=Odkaz na soubor; 3=Textova poznamka; 4=www adresa; 5=Odkaz na adresar

		var control, html = '', title = '';
		switch (value)
		{
			case 1:
				title = _ds.fields['574015,10'].caption;

				var width = _form.$$().clientWidth - (_grid.rect.left + _grid.$$().clientWidth + 20) - 20;

				var query = new Postback(raGetBlob);
				query.set('act', 'gblob');
				query.set('cid', _form.owner.session);
				query.set('afm', _form.name);
				query.set('ads', _ds.name);
				query.set('obj', _ds.name);
				query.set('res', _ds.get('574015,10'));
				query.set('imw', width);


				var src = _form.owner.cgiPath();
				if (_form.owner.isPortalVersion())
					src += '&';
				else
					src += '?';

				src += query.toString();
				html = '<img src="' + src + '" style="width: ' + width + '" />';
				break;

			case 2:
				title = _ds.fields['580733,10'].caption;
				html = _ds.get('580733,10');
				break;

			case 3:
				title = _ds.fields['574073,10'].caption;

				var width = _form.$$().clientWidth - (_grid.rect.left + _grid.$$().clientWidth + 20) - 20;
				var height = _grid.$$().clientHeight - 20;

				html = '<textarea style="width: ' + width + '; height: ' + height + ';" readonly="true">' + _ds.get('574073,10') + '</textarea>';
				break;

			case 4:
				title = _ds.fields['784461,10'].caption;
				var url = _ds.get('784461,10');
				if (url.indexOf('://') == -1)
					url = 'http://' + url;
				html = '<a href="' + url + '" target="_blank">' + _ds.get('784461,10') + '</a>';
				break;

			case 5:
				title = _ds.fields['3704748,10'].caption;
				html = _ds.get('3704748,10');
				break;
		}

		_title.innerHTML = title + ':';
		_valueContainer.innerHTML = html;
	}

	function dispose(form)
	{
		if (_lastControl != null)
		{
			_lastControl.dispose();
			_lastControl = null;
			_valueContainer.innerHTML = '';
			_title.innerHTML = '';
		}

		if ((_ds != null) && (_ds.oncurrentrecordchanged != null))
			_ds.oncurrentrecordchanged.detach(dsChange);
		_ds = null;
		_form = null;
		_grid = null;
	}
}

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();